/*
    Copyright (C) 2007  Oliver Scheuch
    privat_at_oliver-scheuch_dot_de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/

var bounds = new GLatLngBounds();
var overlays = [];
var map;
var pointOnMap;
function showPoint(lat, lng) {
    if (pointOnMap) {
       map.removeOverlay(pointOnMap);
    }
    pointOnMap = new GMarker(new GLatLng(lat, lng)); //, pointIcon);
    map.addOverlay(pointOnMap);
}

function calculateDistance(points) {
    var distance = 0.0;
    for (var i = 1; i < points.length; i++) {
        var distanceToNext = points[i].distanceFrom(points[i - 1])
        distance = distance + distanceToNext;
        points[i-1].distanceToNext = distanceToNext;
    }
    distance = distance / 1000;
        return distance;
    }

processGpx = function(doc) {
    var xmlDoc = GXml.parse(doc)
    var trks = xmlDoc.documentElement.getElementsByTagName("trk");
    var points = [];
    for (var i = 0; i < trks.length; ++ i) {
        var name = GXml.value(trks[i].getElementsByTagName("name")[0]);
        var trkseg = trks[i].getElementsByTagName("trkseg");
        var trkpt = trkseg[0].getElementsByTagName("trkpt");
        for (var o = 0; o < trkpt.length; ++ o) {
            var lat = trkpt[o].getAttribute("lat");
            var lon = trkpt[o].getAttribute("lon");
            var elevation = trkpt[o].getElementsByTagName("ele");
            var height=-100;
            if (elevation && elevation.length == 1) {
                height = Math.round(GXml.value(elevation[0])); 
            }
            addPointToPoints(lat, lon, points, height);
        }
    }
    display(points, name);
}


processKml = function(doc) {
    var xmlDoc = GXml.parse(doc)
    var placemarks = xmlDoc.documentElement.getElementsByTagName("Placemark");
    var ccordinates = xmlDoc.documentElement.getElementsByTagName("coordinates");
    var points = [];
    for (var i = 0; i < ccordinates.length; i++) {
        var coords = GXml.value(ccordinates[i]);
        var regexp = /\s/;
        while (regexp.test(coords)) {
             coords = coords.replace(regexp, "X");
        }
        var path = coords.split("X");
        if (path.length > 1) {
            for (var p = 0; p < path.length - 1; p++) {
                var bits = path[p].split(",");
                addPointToPoints(parseFloat(bits[1]), parseFloat(bits[0]), points, parseFloat(bits[2]));
            }
        }
    }
    display(points);
}

function addPointToPoints(lat, lon, points, height) {
    if (isNaN(lat) || isNaN(lon)) {
        return;
    }
    var point = new GLatLng(lat, lon);
    point.height=height;
    points.push(point);
    bounds.extend(point);
    return point;
}

function addPointsToOverlays(points) {
    overlays.push(new GPolyline(points));
    overlays.push(new GMarker(points[0], startIcon));
    overlays.push(new GMarker(points[points.length - 1], endIcon));
    var markers = (new DistanceMarker(points).createMarkers());
    overlays = overlays.concat(markers);
}
    
display = function(points, name) {
    var sidebar_table = "";
    var height_table = "";
    var height_info_table = "";
    var header_table = "";
  
    if (points.length > 0) {
         addPointsToOverlays(points);
         var minHeight = 200000000;
         var maxHeight = 0;
         var oldHeight = -100;
         var heightMeters = 0;
         for (var i = 0; i < points.length; ++ i) {
  	    if (points[i].height > -100) {
                if (points[i].height > maxHeight) {
                    maxHeight=points[i].height;
                }
               	if (points[i].height < minHeight) {
               	    minHeight=points[i].height;
               	}
               	if (oldHeight > -100) {
               	    if (Math.round(points[i].height) > Math.round(oldHeight) + 2) {
               	        heightMeters += Math.round(points[i].height) - Math.round(oldHeight);
               	     	oldHeight = points[i].height;
               	     } else if (points[i].height > oldHeight){
                     } else {
               	         oldHeight = points[i].height;
               	     }
               	 } else {
                     oldHeight = points[i].height;
                 }
            }       	
         }
         minHeight = Math.round(minHeight);
         maxHeight = Math.round(maxHeight);       
         var distance = this.calculateDistance(points);
         header_table += "<h2>" + name + "</h2>";
         sidebar_table += "Distanz:" + Math.round(distance * 1000) / 1000 + " km<hr />";
         sidebar_table += "Die dargestellte Datei hat "+points.length+" Trackpunkte.<hr />";
         sidebar_table += "H&ouml;henmeter:"+ Math.round(heightMeters)+"m<br />";
         sidebar_table += "max H&ouml;he  :"+ Math.round(maxHeight)+"m<br />";
         sidebar_table += "min H&ouml;he  :"+ Math.round(minHeight)+"m<hr />";
         var filename = window.location.search.substring(1);
         if (filename.indexOf("http://") == -1) {
             filename = window.location.href;
             var index = filename.indexOf("?");
             if (index >= 1) {
                filename = filename.substr(0, index-1);
             }
             index = filename.lastIndexOf("/");
             filename = filename.substr(0, index+1);
             filename += window.location.search.substring(1);
         } 
         sidebar_table += "<a href=\""+filename+"\"/>Download - GPS-Datei </a>";
         var tempDist = 0;
         var currentPoint = 0;
         var heightScale = (maxHeight - (minHeight))/200;
         if (heightScale ==0)heigthScale = 1;
         var oldDelta = -1;
         var step = 10; 
         if (maxHeight - minHeight <100) step = 10;
         else if (maxHeight - minHeight <200) step = 25;
         else if (maxHeight - minHeight <400) step = 50;
         else if (maxHeight - minHeight <800) step = 100;
         else if (maxHeight - minHeight <1600) step = 250;
         else if (maxHeight - minHeight <3000) step = 500;
         else step = 1000;
         var count=0;
         var heightPix;
         var divHeight;
         for (var o= (minHeight +step) - (minHeight%step); o < maxHeight; o+=step) {
             heightPix = 200 - Math.round((o-minHeight) /heightScale);
             divHeight = Math.round(step/heightScale);
             height_table +="<div class=\""+(count%2 == 0 ? "interval_odd" : "interval_even")+"\"style=\"top:"+heightPix+"px; height:"+divHeight+"px;\">&nbsp;</div>";  
             height_table +="<div  class=\"interval_desc\"style=\"top:"+heightPix+"px; height:"+divHeight+"px;\">"+o+"m</div>"; 
             count ++;
         }
         height_table +="<div class=\""+(count%2 == 0 ? "interval_odd" : "interval_even") +"\" style=\"height:"+heightPix+"px;top:0px\">&nbsp;</div>";  
 
         height_table +="<div class=\"heightDiv\" >";
         for (var o=0; o < 768; ++o) {
      	      var delta = (distance * (o)) /  768;
              var image;
              var color;
              var clazz =  (oldDelta != -1 && Math.ceil(delta) > Math.ceil(oldDelta)) ? "heightPxMarker" : "heightPx";
              oldDelta = delta;
              while (delta >= tempDist && (currentPoint+1)<points.length) {
                  tempDist += points[currentPoint].distanceToNext/1000;  	
                  currentPoint ++;
              }
              var height=points[currentPoint].height - minHeight;
	      height= Math.round(height/heightScale)+24;		                
              height_table += "<img src=\"1x1.gif\" class=\""+clazz+"\" height=\""+height+"\" width=\"1\" onmouseover=\"showPoint("+points[currentPoint].lat()+","+ points[currentPoint].lng()+");\"/>" ;
         }
         height_table+="</div>";
    }   
    map = new GMap2(document.getElementById("map"));
    map.addControl(new GLargeMapControl());
    map.addControl(new GMapTypeControl());
    map.addControl(new GScaleControl());
    var czoom = (map.getBoundsZoomLevel(bounds));
    map.setCenter(bounds.getCenter(), czoom);
    for (var j = 0; j < overlays.length; j++) {
        map.addOverlay(overlays[j]);
    }
    document.getElementById("sidebar").innerHTML = sidebar_table;
    document.getElementById("height").innerHTML = height_table;
    document.getElementById("header").innerHTML = header_table;
}


function DistanceMarker(points) {
    this.distanceIcon = new GIcon();
    this.distanceIcon.image = "./star.png";
    this.distanceIcon.iconSize = new GSize(16, 16);
    this.distanceIcon.iconAnchor = new GPoint(8, 8);

    this.points = points;

    this.accuracy = 10;
    this.length = 1000;
    this.kms = 1;
    this.distanceMarkers = new Array();
    this.createMarkers = function() {
        var delta = 0;
        for (var i = 1; i < this.points.length; ++ i) {
            delta = this.calculateTow(this.points[i - 1], this.points[i], delta);
        }
        return this.distanceMarkers;
    }
    this.addMarker = function(point) {
        var opt = new Object();
        opt.clickable = false;
        opt.title = "km " + this.kms;
        opt.icon = this.distanceIcon;
        this.kms++;
        this.distanceMarkers.push(new GMarker(point, opt));
    }

    this.calculateTow = function(first, second, delta) {
        var tmpDistance = delta + first.distanceFrom(second);
        if (tmpDistance < this.length - this.accuracy) {
            return tmpDistance;
        }
        if (tmpDistance < this.length + this.accuracy) {
            this.addMarker(second);
            return tmpDistance - this.length;
        }
        do  {
            var oldDistance = tmpDistance;
            first = this.getNextLatLng(first, second, delta)

            tmpDistance = first.distanceFrom(second);
            delta = oldDistance - tmpDistance - this.length;
            tmpDistance += delta;
            this.addMarker(first);
        } while (tmpDistance > this.length - this.accuracy);
        return tmpDistance;
    }
    this.getNextLatLng = function(first, second, delta) {
        var south;
        var north;
        var west;
        var east;
        if (first.lat() < second.lat()) {
            south = first.lat();
            north = second.lat();
        } else {
            south = second.lat();
            north = first.lat();
        }

        if (first.lng() < second.lng()) {
            east = second.lng();
            west = first.lng();
        } else {
            west = second.lng();
            east = first.lng();
        }
        var abounds = new GLatLngBounds(new GLatLng(south, west), new GLatLng(north, east));
        var center = abounds.getCenter();
        var tmpDistance = delta + first.distanceFrom(center);
        if (tmpDistance > this.length + this.accuracy) {
            return this.getNextLatLng(first, center, delta);
        } else if (tmpDistance < this.length - this.accuracy) {
            return this.getNextLatLng(center, second, tmpDistance);
        } else return center;
    }
}
